/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealthmod.client.configuration;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.torocraft.torohealthmod.client.event.ToroHealthEventHandler;

public class ConfigurationHandler {
    private static Configuration config;
    public static boolean showDamageParticles;
    public static boolean showThroughWalls;
    public static int damageColor;
    public static int healColor;
    public static double size;
    private static final String[] acceptedColors;
    private static ToroHealthEventHandler eventHandler;

    public ConfigurationHandler(File path) {
        if (config == null) {
            config = new Configuration(path);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        showDamageParticles = config.getBoolean("Show Damage Particles", "general", true, "Show Damage Indicators");
        showThroughWalls = config.getBoolean("Render through walls", "general", false, "Render particles though walls");
        size = config.get("general", "Particles Size", size, "Particles Size [default: 3.0]").getDouble();
        healColor = ConfigurationHandler.mapColor(config.getString("Heal Color", "general", "GREEN", "Heal Text Color", acceptedColors));
        damageColor = ConfigurationHandler.mapColor(config.getString("Damage Color", "general", "RED", "Damage Text Color", acceptedColors));
        if (showDamageParticles) {
            if (eventHandler == null) {
                eventHandler = new ToroHealthEventHandler();
                MinecraftForge.EVENT_BUS.register((Object)eventHandler);
            }
        } else if (eventHandler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)eventHandler);
            eventHandler = null;
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("torohealthmod")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    private static int mapColor(String color) {
        int n;
        switch (color) {
            case "RED": {
                n = 0xFF0000;
                break;
            }
            case "GREEN": {
                n = 65280;
                break;
            }
            case "BLUE": {
                n = 255;
                break;
            }
            case "YELLOW": {
                n = 0xFFFF00;
                break;
            }
            case "ORANGE": {
                n = 16753920;
                break;
            }
            case "BLACK": {
                n = 0;
                break;
            }
            case "PURPLE": {
                n = 0x960096;
                break;
            }
            default: {
                n = 0xFFFFFF;
            }
        }
        return n;
    }

    static {
        showDamageParticles = true;
        showThroughWalls = false;
        size = 3.0;
        acceptedColors = new String[]{"RED", "GREEN", "BLUE", "YELLOW", "ORANGE", "WHITE", "BLACK", "PURPLE"};
    }
}

